;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DrawString routine for transparent ;
; background text on Screen 13h      ;
;                                    ;
; (C) Copyright Graham Downey 2016   ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ORG 0h

PUSHA
PUSH ES
PUSH DS

			;INT 10h function AX=1130h will return a pointer
MOV AX, 1130h           ;to a font table
			;BH=3 is the 8x8 base characters table (0-127)
MOV BH, 03h             ;BH=4 is the 8x8 extended characters table (128-255)

INT 10h                 ;On return:
			;CX = bytes per character of on-screen font
			;DL = rows (less 1)
			;ES:BP = pointer to font table

MOV AX, ES              ;We want the font table to be ES:SI
MOV ES, AX
MOV SI, BP              ;Font table is now ES:SI


MOV BP, SP              ;Point BP to stack

			;Start pos in VRAM is [StartX + (StartY*320)]
MOV DX, WORD [BP+16+18] ;Set start Y pos
IMUL AX, DX, 320
ADD AX, WORD [BP+14+18] ;Add start X pos
MOV DI, AX              ;Set DI to position to begin drawing
MOV AX, 0A000h          ;Set Screen segment
MOV DS, AX              ;Screen is now DS:DI

MOV BX, WORD [BP+6+18]  ;Get String Color
MOV CX, WORD [BP+8+18]  ;Get String Length
MOV FS, WORD [BP+10+18] ;Get String Segment
MOV BP, WORD [BP+12+18] ;Get String Address
			;String is now FS:BP

ReadChar:
MOV AH, 00h
MOV AL, BYTE [FS:BP]    ;Read a char from the string
SHL AX, 3               ;Multiply character by 8 (8 bytes per char)
MOV DX, SI              ;Save start position of font table
ADD SI, AX              ;Move table pointer to character we just read

MOV BH, 8               ;8 lines per char

.NextLine:
MOV AL, [ES:SI]         ;Read a row of pixels from the char

.Pixel1:
TEST AL, 1              ;Is there a pixel at bit 1?
JZ .Pixel2              ;No? Jump to pixel 2
MOV [DI+7], BL          ;Draw pixel 1

.Pixel2:
TEST AL, 2              ;Is there a pixel at bit 2?
JZ .Pixel3              ;No? jump to pixel 3

MOV [DI+6], BL          ;Draw pixel 2

.Pixel3:
TEST AL, 4              ;Is there a pixel at bit 3?
JZ .Pixel4              ;No? Jump to pixel 4
MOV [DI+5], BL          ;Draw pixel 3

.Pixel4:
TEST AL, 8              ;Is there a pixel at bit 4?
JZ .Pixel5              ;No? Jump to pixel 5
MOV [DI+4], BL          ;Draw pixel 4

.Pixel5:
TEST AL, 16             ;Is there a pixel at bit 5?
JZ .Pixel6              ;No? Jump to pixel 6
MOV [DI+3], BL          ;Draw pixel 5

.Pixel6:
TEST AL, 32             ;Is there a pixel at bit 6?
JZ .Pixel7              ;No? Jump to pixel 7
MOV [DI+2], BL          ;Draw pixel 6

.Pixel7:
TEST AL, 64             ;Is there a pixel at bit 7?
JZ .Pixel8              ;No? Jump to pixel 8
MOV [DI+1], BL          ;Draw pixel 7

.Pixel8:
TEST AL, 128            ;Is there a pixel at bit 8?
JZ .EndOfRow            ;No? Skip drawing pixel
MOV [DI], BL            ;Draw pixel 8

.EndOfRow:
INC SI                  ;Next byte on font table
ADD DI, 320             ;Go to next line on screen

DEC BH                  ;Done all 8 lines of char?
JNZ .NextLine           ;No? Start over on next line
MOV SI, DX              ;Restore to start of table
SUB DI, 2560-8          ;Done a char, return to top line and move 
			;8 pixels forward for next character

INC BP                  ;Next char in string pointer
DEC CX                  ;Are we done the string?
JNZ ReadChar            ;No? Repeat until done


End:
POP DS
POP ES
POPA
RETF
