''''''''''''''''''''''''''''''''''''''''''''''
'      DrawString Routine for Screen 13      '
'                                            '
' A quick demo program I threw together to   '
' show how easy this routine is to use and   '
' exactly how it works                       '
'                                            '
' (C) Copyright 2016 Graham Downey           '
'                                            '
''''''''''''''''''''''''''''''''''''''''''''''
DECLARE SUB BoldPrint (X%, Y%, C%, S$)
DECLARE SUB DrawString (X%, Y%, C%, S$)
DECLARE SUB PrintBorder (X%, Y%, C1%, C2%, S$)
DECLARE SUB Print3D (X%, Y%, DirectionX%, DirectionY%, C1%, C2%, S$)
DECLARE SUB ShadowPrint (X%, Y%, OffsetX%, OffsetY%, C1%, C2%, S$)
DEFINT A-Z

SCREEN 13   'Only works in Screen 13

'Make the background a nice grey
LINE (0, 0)-(319, 199), &H19, BF

LOCATE 2, 1: PRINT "When you use PRINT, it changes the"
PRINT "background color to black and looks ugly"

DrawString 1, 37, &H1F, "However using DrawString it prints with"
DrawString 1, 47, &H1F, "a transparent background."

DrawString 1, 70, &H1F, "You can also do cool overlapping text"
DrawString 1, 79, &H1F, "effects like"
BoldPrint 105, 79, &H1F, "BOLD,"
ShadowPrint 153, 78, 2, 2, &H1F, &H15, "shadows,"
Print3D 226, 80, -1, -1, 1, &H1F, "3D text"
DrawString 290, 79, &H1F, "and"
PrintBorder 1, 88, &H10, &H1F, "bordered text"
DrawString 114, 88, &H1F, "with it!"

DrawString 1, 106, &H1F, "And if you get creative you can do cool"
DrawString 1, 115, &H1F, "animations"

'Marquee vars
DIM sMarquee AS STRING: sMarquee = SPACE$(40) + "and marquee!" + SPACE$(40)
DIM MoveTime AS SINGLE, XPos AS INTEGER, XStep AS INTEGER

'Wave vars
DIM WaveTime AS SINGLE, Angle AS SINGLE, sWave AS STRING, I AS INTEGER
DIM iX AS INTEGER, iSplit AS INTEGER
sWave = "waving colorized text..."

'Blink vars
DIM Blink AS INTEGER, BlinkTime AS SINGLE

XPos = 1: XStep = 0: iSplit = 1
MovDirection = -4

'Ribbon for marquee
LINE (4, 165)-(315, 178), &H2B, B
LINE (5, 166)-(314, 177), &H20, BF

DrawString 1, 191, &H1F, "Press any key to stop..."
DO
   KeyHit$ = INKEY$

   'Blink text
   IF ABS(BlinkTime - TIMER) > .5 THEN
      BlinkTime = TIMER
      IF Blink THEN
         Blink = 0: DrawString 88, 115, &H1F, "like <BLINK>"
      ELSE
         Blink = -1: DrawString 88, 115, &H19, "like <BLINK>"
      END IF
   END IF

   'Waving text
   IF ABS(WaveTime - TIMER) >= .02745 THEN
      WaveTime = WaveTime + .02745
      IF ABS(WaveTime - TIMER) >= .5 THEN WaveTime = TIMER
      FOR I = iSplit TO iSplit + 11
         iX = 52 + I * 8: LINE (iX, 136)-(iX + 7, 151), &H19, BF
         DrawString iX, 140 + SIN(Angle + I * .5) * 4, I + &H20, MID$(sWave, I, 1)
      NEXT I
      iSplit = iSplit XOR 12
      IF iSplit = 1 THEN
         Angle = Angle + .5: IF Angle > 6.28318 THEN Angle = Angle - 6.28318
      END IF
   END IF

   'Marquee text
   IF ABS(MoveTime - TIMER) >= .02745 THEN
      MoveTime = MoveTime + .02745
      IF ABS(MoveTime - TIMER) >= .5 THEN MoveTime = TIMER
      sTemp$ = MID$(sMarquee, XPos, 40)
      WAIT &H3DA, 8: WAIT &H3DA, 8, 8     'Wait for VSYNC to remove flicker
      LINE (5, 166)-(314, 177), &H20, BF
      DrawString 4 - XStep, 168, &H2B, sTemp$
      LINE (0, 166)-(3, 177), &H19, BF
      LINE (316, 166)-(319, 177), &H19, BF
      XStep = (XStep + 2) AND 7
      IF XStep = 0 THEN
         XPos = XPos + 1: IF XPos > LEN(sMarquee) - 40 THEN XPos = 1
      END IF
   END IF
LOOP WHILE KeyHit$ = ""

DEFSNG A-Z
SUB BoldPrint (X%, Y%, C%, S$)
   DrawString X%, Y%, C%, S$
   DrawString X% + 1, Y%, C%, S$
END SUB

SUB DrawString (X%, Y%, C%, S$) STATIC
   IF iInit = 0 THEN 'Generate once, don't regenerate later
      iInit = 1
      REDIM ASM(36) AS LONG
      ASM(0) = &HB81E0660: ASM(1) = &H3B71130: ASM(2) = &HC08C10CD
      ASM(3) = &HEE89C08E: ASM(4) = &H568BE589: ASM(5) = &H40C26922
      ASM(6) = &H20460301: ASM(7) = &HB8C789: ASM(8) = &H8BD88EA0
      ASM(9) = &H4E8B185E: ASM(10) = &H1C668E1A: ASM(11) = &HB41E6E8B
      ASM(12) = &H468A6400: ASM(13) = &H3E0C100: ASM(14) = &HC601F289
      ASM(15) = &H8A2608B7: ASM(16) = &H7401A804: ASM(17) = &H75D8803
      ASM(18) = &H37402A8: ASM(19) = &HA8065D88: ASM(20) = &H88037404
      ASM(21) = &H8A8055D: ASM(22) = &H5D880374: ASM(23) = &H7410A804
      ASM(24) = &H35D8803: ASM(25) = &H37420A8: ASM(26) = &HA8025D88
      ASM(27) = &H88037440: ASM(28) = &H80A8015D: ASM(29) = &H1D880274
      ASM(30) = &H40C78146: ASM(31) = &H75CFFE01: ASM(32) = &H81D689BD
      ASM(33) = &H4509F8EF: ASM(34) = &H1FA47549: ASM(35) = &HCB6107
   END IF
   DEF SEG = VARSEG(ASM(0))
   CALL absolute(BYVAL Y%, BYVAL X%, BYVAL SADD(S$), BYVAL SSEG(S$), BYVAL LEN(S$), BYVAL C%, VARPTR(ASM(0)))
END SUB

SUB Print3D (X%, Y%, DirectionX%, DirectionY%, C1%, C2%, S$)
   DrawString X%, Y% + DirectionY%, C2%, S$
   DrawString X% + DirectionX%, Y%, C2%, S$
   DrawString X%, Y%, C1%, S$
END SUB

SUB PrintBorder (X%, Y%, C1%, C2%, S$)
   DrawString X% + 1, Y%, C2%, S$
   DrawString X%, Y% + 1, C2%, S$
   DrawString X% - 1, Y%, C2%, S$
   DrawString X%, Y% - 1, C2%, S$
   DrawString X%, Y%, C1%, S$
END SUB

SUB ShadowPrint (X%, Y%, OffsetX%, OffsetY%, C1%, C2%, S$)
   DrawString X% + OffsetX%, Y% + OffsetY%, C2%, S$
   DrawString X%, Y%, C1%, S$
END SUB

